/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.Map;
import technology.rocketjump.undermount.assets.characterviewer.PlantAssetModifier;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class PlantViewUI
implements Disposable {
    private Skin uiSkin = new Skin(Gdx.files.internal("assets/ui-skins/libgdx-default/uiskin.json"));
    private Stage stage;
    private Table containerTable;
    private TextButton branchColorButton;
    private TextButton leafColorButton;
    private TextButton showLeavesButton;
    private Entity currentEntity;
    private Map<EntityAssetType, EntityAsset> assetMap;
    private PlantEntityAttributes entityAttributes;
    private final PlantAssetModifier plantAssetModifier;
    private final EntityAssetTypeDictionary assetTypeDictionary;
    private final PlantSpeciesDictionary plantSpeciesDictionary;

    @Inject
    public PlantViewUI(PlantAssetModifier plantAssetModifier, EntityAssetTypeDictionary assetTypeDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.plantAssetModifier = plantAssetModifier;
        this.assetTypeDictionary = assetTypeDictionary;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
        this.stage = new Stage(new ScreenViewport());
        this.containerTable = new Table(this.uiSkin);
        this.containerTable.setFillParent(true);
        this.stage.addActor(this.containerTable);
        this.containerTable.pad(20.0f);
        this.containerTable.left().top();
    }

    public void init(Entity entity) {
        this.currentEntity = entity;
        this.entityAttributes = (PlantEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        this.assetMap = entity.getPhysicalEntityComponent().getTypeMap();
        this.containerTable.clearChildren();
        this.createSpeciesWidget();
        this.containerTable.row();
        this.createPlantSizeWidget();
        this.containerTable.row();
        this.createBranchColorOffsetWidget();
        this.containerTable.row();
        this.createLeafOffsetColorWidget();
        this.containerTable.row();
        this.createShowLeavesWidget();
        this.containerTable.row();
        this.updateAttributes(this.entityAttributes);
    }

    private void createPlantSizeWidget() {
        this.containerTable.add(new Label((CharSequence)"Size: ", this.uiSkin));
        final SelectBox<String> plantSizeSelect = new SelectBox<String>(this.uiSkin);
        plantSizeSelect.setItems("1", "2", "3", "4");
        plantSizeSelect.setSelected(String.valueOf(this.entityAttributes.getCurrentTileHeight()));
        plantSizeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int selectedSize = Integer.parseInt((String)plantSizeSelect.getSelected());
                PlantViewUI.this.entityAttributes.setCurrentTileHeight(selectedSize);
                PlantViewUI.this.plantAssetModifier.changePlantSize(selectedSize);
                PlantViewUI.this.showLeavesButton.setText("On");
            }
        });
        this.containerTable.add(plantSizeSelect);
    }

    private void createSpeciesWidget() {
        final SelectBox speciesSelect = new SelectBox(this.uiSkin);
        Array<String> speciesNames = new Array<String>();
        for (PlantSpecies plantSpecies : this.plantSpeciesDictionary.getAll()) {
            speciesNames.add(plantSpecies.getSpeciesName());
        }
        speciesSelect.setItems(speciesNames);
        speciesSelect.setSelected(this.entityAttributes.getSpecies().getSpeciesName());
        speciesSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedSpeciesName = (String)speciesSelect.getSelected();
                PlantSpecies selectedSpecies = PlantViewUI.this.plantSpeciesDictionary.getByName(selectedSpeciesName);
                PlantViewUI.this.entityAttributes.setSpecies(selectedSpecies);
                PlantViewUI.this.plantAssetModifier.changeSpecies(selectedSpecies);
                PlantViewUI.this.showLeavesButton.setText("On");
            }
        });
        this.containerTable.add(new Label((CharSequence)"Species:", this.uiSkin), speciesSelect);
    }

    private void createLeafOffsetColorWidget() {
        this.containerTable.add(new Label((CharSequence)"Leaf color: ", this.uiSkin));
        this.leafColorButton = new TextButton("#rrggbb", this.uiSkin);
        this.leafColorButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color newColor = PlantViewUI.this.entityAttributes.getSpecies().randomLeafColor(new RandomXS128());
                PlantViewUI.this.entityAttributes.setActualLeafColor(newColor);
                PlantViewUI.this.updateAttributes(PlantViewUI.this.entityAttributes);
            }
        });
        this.containerTable.add(this.leafColorButton);
    }

    private void createBranchColorOffsetWidget() {
        this.containerTable.add(new Label((CharSequence)"Branch color: ", this.uiSkin));
        this.branchColorButton = new TextButton("#rrggbb", this.uiSkin);
        this.branchColorButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Color newColor = PlantViewUI.this.entityAttributes.getSpecies().randomBranchColor(new RandomXS128());
                PlantViewUI.this.entityAttributes.setActualBranchColor(newColor);
                PlantViewUI.this.updateAttributes(PlantViewUI.this.entityAttributes);
            }
        });
        this.containerTable.add(this.branchColorButton);
    }

    private void createShowLeavesWidget() {
        this.containerTable.add(new Label((CharSequence)"Show leaves: ", this.uiSkin));
        this.showLeavesButton = new TextButton("On", this.uiSkin);
        this.showLeavesButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean showLeaves = PlantViewUI.this.showLeavesButton.getText().toString().equals("On");
                boolean bl = showLeaves = !showLeaves;
                if (showLeaves) {
                    PlantViewUI.this.showLeavesButton.setText("On");
                } else {
                    PlantViewUI.this.showLeavesButton.setText("Off");
                }
                if (showLeaves) {
                    PlantViewUI.this.entityAttributes.setLeafColorChangeAmount(0.0f);
                } else {
                    PlantViewUI.this.entityAttributes.setLeafColorChangeAmount(-1.0f);
                }
            }
        });
        this.containerTable.add(this.showLeavesButton);
    }

    public void render() {
        this.stage.act();
        this.stage.draw();
    }

    public void onResize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public void updateAttributes(PlantEntityAttributes entityAttributes) {
        this.entityAttributes = entityAttributes;
        Color branchColor = entityAttributes.getActualBranchColor();
        this.branchColorButton.setColor(branchColor.cpy());
        this.branchColorButton.setText(this.colorToString(branchColor));
        Color leafColor = entityAttributes.getActualLeafColor();
        this.leafColorButton.setColor(leafColor.cpy());
        this.leafColorButton.setText(this.colorToString(leafColor));
    }

    private String colorToString(Color color) {
        return "#" + color.toString().substring(0, 6);
    }

    public Stage getStage() {
        return this.stage;
    }
}

